<?php
// ===== Headers & CORS =====
header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Headers: Content-Type');
header('Access-Control-Allow-Methods: GET, POST, OPTIONS');
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') { http_response_code(204); exit; }

// (évite tout texte parasite avant le JSON)
@ini_set('display_errors', 0);
@ini_set('html_errors', 0);
if (function_exists('ob_get_level')) { while (ob_get_level()) { ob_end_clean(); } }
ob_start();

// ===== MySQL =====
$DB_HOST = 'mysql-gp-eff.alwaysdata.net';
$DB_NAME = 'gp-eff_num';
$DB_USER = 'gp-eff';
$DB_PASS = 'Astres067550*';

// ===== Crypto (⚠ change-les et garde-les secrets) =====
const ENC_METHOD = 'AES-256-CBC';
const ENC_KEY    = 'remplace-par-une-cle-tres-longue-et-secrete-32+chars';
const ENC_IV     = 'iv_16_caracteres!'; // 16 caractères exactement

$GROUPS = ['Matin','Après-midi','Nuit','Prestation','Groupage'];

// ===== Connexion =====
try {
  $pdo = new PDO(
    "mysql:host=$DB_HOST;dbname=$DB_NAME;charset=utf8mb4",
    $DB_USER, $DB_PASS,
    [ PDO::ATTR_ERRMODE=>PDO::ERRMODE_EXCEPTION, PDO::ATTR_DEFAULT_FETCH_MODE=>PDO::FETCH_ASSOC ]
  );
} catch (Throwable $e) {
  if (ob_get_length()) ob_clean();
  echo json_encode(['ok'=>false,'error'=>'db_connect_failed']); exit;
}

// ===== Helpers =====
function norm_phone(string $p=''): string {
  $d = preg_replace('/[^\d+]/','', $p);
  if ($d==='') return '';
  return ($d[0]==='+') ? $d : ('+'.ltrim($d,'+'));
}
function encrypt_phone(string $plain): string {
  if ($plain==='') return '';
  $enc = openssl_encrypt($plain, ENC_METHOD, ENC_KEY, 0, ENC_IV);
  return $enc ?: '';
}
function decrypt_phone_maybe(string $stored): string {
  if ($stored==='') return '';
  $dec = @openssl_decrypt($stored, ENC_METHOD, ENC_KEY, 0, ENC_IV);
  if (is_string($dec) && $dec!=='' && preg_match('/^\+\d{6,20}$/', $dec)) return $dec;
  if (preg_match('/^\+\d{6,20}$/', $stored)) return $stored; // compat ancien clair
  return '';
}
function normalize_group(?string $g): string {
  global $GROUPS;
  return in_array($g, $GROUPS, true) ? $g : 'Matin';
}

// ===== Routes =====
$method = $_SERVER['REQUEST_METHOD'];

if ($method === 'GET') {
  $out = array_fill_keys($GROUPS, []);
  try {
    $rs = $pdo->query("SELECT id,name,phone,grp FROM contacts_xdock ORDER BY name");
    foreach ($rs as $r) {
      $grp = normalize_group($r['grp']);
      $out[$grp][] = [
        'id'    => (int)$r['id'],
        'name'  => $r['name'],
        'phone' => decrypt_phone_maybe($r['phone']),
        'group' => $grp
      ];
    }
    if (ob_get_length()) ob_clean();
    echo json_encode($out, JSON_UNESCAPED_UNICODE); exit;
  } catch (Throwable $e) {
    if (ob_get_length()) ob_clean();
    echo json_encode(['ok'=>false,'error'=>'sql_error','msg'=>$e->getMessage()]); exit;
  }
}

if ($method === 'POST') {
  $in = json_decode(file_get_contents('php://input'), true) ?: [];
  $action = $in['action'] ?? '';

  if ($action === 'upsert') {
    $c = $in['contact'] ?? [];
    $id    = isset($c['id']) ? (int)$c['id'] : 0;
    $name  = trim($c['name']  ?? '');
    $phone = norm_phone($c['phone'] ?? '');
    $grp   = normalize_group($c['group'] ?? '');

    if ($name==='' || $phone==='') {
      if (ob_get_length()) ob_clean();
      echo json_encode(['ok'=>false,'error'=>'invalid_fields']); exit;
    }

    $enc = encrypt_phone($phone);

    // anti-doublon (exclut la ligne en cours si update)
    $sqlCheck = "SELECT id FROM contacts_xdock WHERE phone=? " . ($id>0 ? "AND id<>?" : "");
    $st = $pdo->prepare($sqlCheck);
    $st->execute($id>0 ? [$enc,$id] : [$enc]);
    if ($st->fetch()) {
      if (ob_get_length()) ob_clean();
      echo json_encode(['ok'=>false,'error'=>'duplicate_phone']); exit;
    }

    try {
      if ($id>0) {
        $st = $pdo->prepare("UPDATE contacts_xdock SET name=?, phone=?, grp=? WHERE id=?");
        $st->execute([$name,$enc,$grp,$id]);
        if (ob_get_length()) ob_clean();
        echo json_encode(['ok'=>true]); exit;
      } else {
        $st = $pdo->prepare("INSERT INTO contacts_xdock(name,phone,grp) VALUES (?,?,?)");
        $st->execute([$name,$enc,$grp]);
        if (ob_get_length()) ob_clean();
        echo json_encode(['ok'=>true,'id'=>$pdo->lastInsertId()]); exit;
      }
    } catch (Throwable $e) {
      if (ob_get_length()) ob_clean();
      echo json_encode(['ok'=>false,'error'=>'sql_error','msg'=>$e->getMessage()]); exit;
    }
  }

  if ($action === 'delete') {
    $id = (int)($in['id'] ?? 0);
    try {
      $st = $pdo->prepare("DELETE FROM contacts_xdock WHERE id=?");
      $st->execute([$id]);
      if (ob_get_length()) ob_clean();
      echo json_encode(['ok'=>true]); exit;
    } catch (Throwable $e) {
      if (ob_get_length()) ob_clean();
      echo json_encode(['ok'=>false,'error'=>'sql_error','msg'=>$e->getMessage()]); exit;
    }
  }

  if (ob_get_length()) ob_clean();
  echo json_encode(['ok'=>false,'error'=>'unknown_action']); exit;
}

http_response_code(405);
if (ob_get_length()) ob_clean();
echo json_encode(['ok'=>false,'error'=>'method_not_allowed']);
